;;; - ------------------------------------------------------------------------------ - ;
;;; -                T O O L - A C M  - A T T S E T V A L U E                        - ;
;;; - ------------------------------------------------------------------------------ - ;
;;; - Beschreibung : Auswahl von Blockreferenzen in Abhngigkeit von Blockname       - ;
;;; -                Attributname und Attributwert und ndern der Attribute auf      - ;
;;; -                einen neuen Wert                                                - ;
;;; - Befehle      : ATTSETVALUE                                                     - ;
;;; - ------------------------------------------------------------------------------ - ;
;;; - letzte nderung am : 05.08.2025                                                - ;
;;; -              durch : Thomas Krger                                             - ;
;;; - ------------------------------------------------------------------------------ - ;
(defun C:ATTSETVALUE (/ BLOCKNAMEFILTER TAGSTRINGFILTER VALUEFILTER INSERTS AWS
                         BLOCKSEARCH BLOCKSEARCHDLG DLGRETURN
                     )
  (defun ATTSETVALUE(BLOCKNAMEFILTER TAGSTRINGFILTER VALUEFILTER NEWVALUE / INSERTS ATTLIST)
    (if(and(or(and(=(type BLOCKNAMEFILTER) 'LIST)
                  (setq BLOCKNAMEFILTER
                         (vl-remove-if-not'(lambda(X)(=(type X)'STR))BLOCKNAMEFILTER)
                  )
                  (setq BLOCKNAMEFILTER
                         (vl-string-right-trim ","
                           (apply 'strcat (mapcar
                                            '(lambda(X)(strcat X ","))
                                            BLOCKNAMEFILTER
                                          )
                           )
                         )
                  )
                  (/= BLOCKNAMEFILTER "")
              )
              (setq BLOCKNAMEFILTER "*")
           )
           (or(and(=(type TAGSTRINGFILTER) 'LIST)
                  (setq TAGSTRINGFILTER
                         (vl-remove-if-not'(lambda(X)(=(type X)'STR))TAGSTRINGFILTER)
                  )
                  (setq TAGSTRINGFILTER
                         (vl-string-right-trim ","
                           (apply 'strcat (mapcar
                                            '(lambda(X)(strcat X ","))
                                            TAGSTRINGFILTER
                                          )
                           )
                         )
                  )
                  ;(/= TAGSTRINGFILTER "")
              )
              (and(= TAGSTRINGFILTER "")(= VALUEFILTER "")) ;;
              (setq TAGSTRINGFILTER "*")
           )
           (or(and(=(type VALUEFILTER) 'LIST)
                  (setq VALUEFILTER
                         (vl-remove-if-not'(lambda(X)(=(type X)'STR))VALUEFILTER)
                  )
                  (setq VALUEFILTER
                         (vl-string-right-trim ","
                           (apply 'strcat (mapcar
                                            '(lambda(X)(strcat X ","))
                                            VALUEFILTER
                                          )
                           )
                         )
                  )
                  ;(/= VALUEFILTER "")
              )
              (and(= TAGSTRINGFILTER "")(= VALUEFILTER ""))
              (setq VALUEFILTER "*")
           )
           (or(=(type NEWVALUE) 'STR)(setq  NEWVALUE ""))

           (or(initget "Fensterauswahl Alle")'T)
           (if(=(getkword "\nBlockauswahl [Fensterauswahl/Alle] ? :<Alle> ")"Fensterauswahl")
             (or(setq INSERTS (ssget (list '(0 . "INSERT")'(66 . 1)(cons 410 (getvar "CTAB")))))
                (prompt"\nKeine Blockreferenzen mit attributen in der Auswahl")
             )                
             (or(setq INSERTS (ssget "_x" (list '(0 . "INSERT")'(66 . 1)(cons 410 (getvar "CTAB")))))
                (prompt"\nKeine Blockreferenzen im aktuellen Layout gefunden")
             )
           )     
           

           (setq INSERTS(mapcar
                         '(lambda(X / ITEM ATTRIBUTES ATTRIBUT FOUND)
                            (if(and(setq ITEM(vlax-ename->vla-object (cadr X)))
                                   (member(strcase(vla-get-objectname  ITEM))
                                          '("ACDBBLOCKREFERENCE" "ACDBMINSERTBLOCK")
                                   )
                                   (or(and(vlax-property-available-p ITEM "IsDynamicBlock")
  		                          (=(vla-get-IsDynamicBlock ITEM):vlax-true)
  		                          (setq BLOCKNAME (vla-get-effectivename ITEM))
                                      )    
                                      (setq BLOCKNAME (vla-get-Name ITEM))
                                   )
                                   (=(type  BLOCKNAME) 'STR)
                                   (or(wcmatch (strcase BLOCKNAME)(strcase BLOCKNAMEFILTER))
                                      (=(strcase BLOCKNAME)(strcase BLOCKNAMEFILTER))
                                   )   
                                )
                               (cond
                                  ((and(= TAGSTRINGFILTER "")(= VALUEFILTER "")) ITEM);_Blcke ohne Attribute
                                  ((and(=(vla-get-hasattributes ITEM) :vlax-true)     ;_Blcke mit Attributen
                                       (setq ATTRIBUTES (vlax-variant-value(vla-getattributes ITEM)))
                                       (=(vlax-safearray-get-dim ATTRIBUTES)1)
                                       (<=(vlax-safearray-get-l-bound ATTRIBUTES 1)
                                          (vlax-safearray-get-u-bound ATTRIBUTES 1)
                                       )
                                   )
                                     (foreach ATTRIBUT (vlax-safearray->list ATTRIBUTES)
                                       (if(and(=(type(setq TAGSTRING(vla-get-Tagstring ATTRIBUT)))'STR) 
                                              (wcmatch (strcase TAGSTRING)(strcase TAGSTRINGFILTER))
                                              (=(type(setq TEXTSTRING(vla-get-Textstring ATTRIBUT)))'STR)
                                              (wcmatch (strcase TEXTSTRING)(strcase VALUEFILTER))
                                          )
                                         (progn
                                           (setq FOUND 'T)
                                           (if(not(vl-catch-all-error-p
                                                    (vl-catch-all-apply' vla-put-Textstring (list ATTRIBUT NEWVALUE))
                                                   )
                                              )                        
                                              (setq ATTLIST (cons ATTRIBUT ATTLIST))
                                           )
                                         )  
                                       )
                                     )
                                    (if FOUND ITEM)
                                  )
                               )
                            )
                          )
                          (ssnamex INSERTS)
                       )
           )
           (setq INSERTS(vl-remove-if 'null INSERTS))
       )
      INSERTS
    )
  )
  
  (defun GETATTINFO(ATTRIB / TAGSTRING DOC OWNER BLOCKNAME TEXTSTRING)
    (if(and(setq ATTRIB(cond               
                         ((=(type ATTRIB) 'VLA-object)ATTRIB)
                         ((=(type ATTRIB) 'Ename)(vlax-ename->vla-object ATTRIB))
                       )
           )
           (=(strcase(vla-get-objectname ATTRIB)) "ACDBATTRIBUTE")
           (setq TAGSTRING  (vla-get-TAGSTRING  ATTRIB))
           (setq TEXTSTRING (vla-get-Textstring ATTRIB))
           (setq DOC  (vla-get-document ATTRIB))             	 
           (setq OWNER(cond
                        ((and(>(vl-string-search "x64" (getvar "PLATFORM"))0)
			     (vlax-method-applicable-p  (vla-get-Document ATTRIB) "ObjectIdToObject32")
                             (vlax-property-available-p ATTRIB "ownerid32")
                         )
                          (vlax-invoke-method
                            (vla-get-Document ATTRIB)'ObjectIdToObject32
                            (vla-get-ownerid32 ATTRIB)
                          )
                        )                     
                        ('T
                          (vlax-invoke-method
                            (vla-get-Document ATTRIB)'ObjectIdToObject
                            (vla-get-ownerid ATTRIB)
                          )
                        )
                      )  
           )           
           (or(and(vlax-property-available-p OWNER "IsDynamicBlock")
  		(=(vla-get-IsDynamicBlock OWNER):vlax-true)
  		(setq BLOCKNAME (vla-get-effectivename OWNER))
              )    
              (setq BLOCKNAME (vla-get-Name OWNER))
           )
       )
      (list BLOCKNAME TAGSTRING TEXTSTRING)
    )
  )
  (defun ATTSETVALUEDLG ( / WRITE-DCL DLG-CHECK DLG-RUN BLKNAME ATTNAME ATTWERT)
    (defun WRITE-DCL(/ DIR POS FILE)
      (if(and(setq DIR(vl-filename-mktemp (strcat "ATTSETVALUEDLG.DCL")))
             (setq FILE (open DIR "w"))
         )
        (progn
          (mapcar
             '(lambda (X)
                (princ (strcat X "\n") FILE)
              )
            '(
                ""
                "ATTSETVALUE"
                ": dialog"
                "{  key = DLGTITEL;   "         
                "   : row   "
                "   {"
                "     : boxed_column"
                "     { width = 60;"
                "       fixed_width = true;"
                "           : button"
                "           { label = \"Vorgabeattribut whlen..\";"
                "             key   = \"OBJEKT\";"
                "             fixed_width = true;"
                "             width = 59;"
                "             alignment = right;"
                "           }"
                "       : row "
                "       {  height = 1;"
                "          fixed_height = true;"
                "          alignment = centered;"              
                "         : column"
                "         { width = 28;"
                "           fixed_width = true;"
                "           : text"
                "           { "
                "             key   = \"TEXT1\";"
                "             label = \"Filter Blockname\";"
                "             alignment = left;"
                "           }"
                "           : text"
                "           { "
                "             key   = \"TEXT2\";"
                "             label = \"Filter Attributsname\";"
                "             alignment = left;"
                "           }"
                "           : text"
                "           { "
                "             key   = \"TEXT3\";"
                "             label = \"Filter Attributswert\";"
                "             alignment = left;"
                "           }"
                "           : text"
                "           { "
                "             key   = \"TEXT4\";"
                "             label = \"Neuer Attributswert\";"
                "             alignment = left;"
                "           }"
                "         }"
                "         : column"
                "         { width = 27;"
                "           fixed_width = true;"
                "           : edit_box"
                "           { label       = \"\";"
                "             key         = \"BLKNAME\";"
                "             width       = 25;"
                "             fixed_width = true;"
                "             height      = 1;"
                "             fixed_height= true;"
                "             alignment   = left;"
                "           }"                                                         
                "           : edit_box"
                "           { label       = \"\";"
                "             key         = \"ATTNAME\";"
                "             width       = 25;"
                "             fixed_width = true;"
                "             height      = 1;"
                "             fixed_height= true;"
                "             alignment   = left;"
                "           }"                                
                "           : edit_box"
                "           { label       = \"\";"
                "             key         = \"ATTWERT\";"
                "             width       = 25;"
                "             fixed_width = true;"
                "             height      = 1;"
                "             fixed_height= true;"
                "             alignment   = left;"
                "           }"
                "           : edit_box"
                "           { label       = \"\";"
                "             key         = \"NEWATTWERT\";"
                "             width       = 25;"
                "             fixed_width = true;"
                "             height      = 1;"
                "             fixed_height= true;"
                "             alignment   = left;"
                "           }"
                "         }"             
                "       }"
                "       : row "
                "       {"
                "          height = 1;"
                "          fixed_height = true;"
                "       } "                
                "     }"
                "   }"                
                "  : row"
                "  {"
                "    "
                "    : button"
                "    { label = \"OK\";"
                "      key   = \"OK\";"
                "      fixed_width = true;"
                "      width = 19;"
                "      alignment = right;"
                "      mnemonic =\"O\";"
                "    }"
                "    : cancel_button"
                "    { label = \"Abbruch\";"
                "      key = \"CANCEL\";"
                "      fixed_width = true;"
                "      width = 19;"
                "      alignment = right;"
                "      mnemonic =\"A\"; "
                "      is_cancel = true;"
                "    }"
                "    : button"
                "    { label = \"Info\";"
                "      key   = \"INFO\";"
                "      fixed_width = true;"
                "      width = 19;"
                "      alignment = right;"
                "      mnemonic =\"I\";"
                "    }"
                "    "
                "  }  "
                "}"
                ""
              )
           )
           (close FILE)
           DIR
         )
       )
    )
    (defun DLG-CHECK()
      (or(/=(setq BLKNAME(get_tile  "BLKNAME"))"")(setq BLKNAME "*"))
      (setq ATTNAME(get_tile  "ATTNAME"))
      (setq ATTWERT(get_tile  "ATTWERT"))
      (setq NEWATTWERT(get_tile  "NEWATTWERT"))
      (list BLKNAME ATTNAME ATTWERT NEWATTWERT)
    )        
    (defun DLG-RUN(DIR / DLGINDEX EXIT? NR BLKNAME ATTNAME ATTWERT)
      (setq BLKNAME "*" ATTNAME "*" ATTWERT "*" NEWATTWERT "")
      (while (not EXIT?)
        (if(>(setq DLGINDEX (load_dialog DIR))0)
          (if(new_dialog "ATTSETVALUE" DLGINDEX)
            (progn            
              (set_tile  "DLGTITEL" "ACM-ATTSETVALUE  Th.Krger 2025 ")
              (set_tile  "BLKNAME"  BLKNAME)
              (set_tile  "ATTNAME"  ATTNAME)
              (set_tile  "ATTWERT"  ATTWERT)
              (action_tile "OBJEKT"       "(done_dialog 5)")
              (action_tile "OK"           (strcat
                                            "(setq RETURN(DLG-CHECK))"
                                            "(done_dialog 1)"                                          
                                          )  
              )
              (action_tile "CANCEL"       "(setq RETURN            nil)(done_dialog 0)")
              (action_tile "INFO"         "(alert(strcat \"=========== ACM-ATTSETVALUE  ==========\n\n\"
                                                         \"       Attributwert entsprechend Filter setzen\n\"                                                         
                                                         \"\t\t Th.Krger 2025     \n\"
                                                         \"\t\t  tk@cad-od.de\n\"
                                                 )
                                           )"      
              )                                    
              (setq EXIT? (start_dialog)) 
              (cond         
                ((= EXIT? 5)  
                  (if(and(not(vl-catch-all-error-p
                               (setq DUMMY(vl-catch-all-apply
                                            'nentsel (list "\nAttribut whlen : ")
                                          )
                               )      
                             )
                         )
                         (setq DUMMY(car DUMMY))
                         (setq DUMMY(GETATTINFO DUMMY))                                      
                     )                      
                    (progn
                      (list BLOCKNAME TAGSTRING TEXTSTRING)
                      (if(=(type(car   DUMMY))'STR)(setq BLKNAME  (car   DUMMY))(setq BLKNAME  "*"))
                      (if(=(type(cadr  DUMMY))'STR)(setq ATTNAME  (cadr  DUMMY))(setq ATTNAME  "*"))
                      (if(=(type(caddr DUMMY))'STR)(setq ATTWERT  (caddr DUMMY))(setq ATTWERT  "*"))
                    )   
                    (alert "Kein Attribut gewhlt!")
                  )
                  (setq EXIT? nil)   
                )
                ('T(setq EXIT? 'T))      
              )                    
              (unload_dialog DLGINDEX)
            )
            (progn (alert "Fehler bei der Dialoginitialisierung")(setq EXIT? 'T))
          )
          (progn (alert "Dialog nicht gefunden")(setq EXIT? 'T))
        )  
      )    
      RETURN
    )
    (if(and(setq DCLFILE(WRITE-DCL))(setq DCLFILE(findfile DCLFILE)))       
      (progn
        (setq RETURN(DLG-RUN DCLFILE))       
        (vl-file-delete DCLFILE)
        RETURN
      )
    )  
  )
  
  (if (=(getvar "CMDDIA")1)
    (if(and(setq DLGRETURN(ATTSETVALUEDLG))
           (or(=(type(setq BLOCKNAMEFILTER(car    DLGRETURN)))'STR)(setq BLOCKNAMEFILTER "*"))
           (or(=(type(setq TAGSTRINGFILTER(cadr   DLGRETURN)))'STR)(setq TAGSTRINGFILTER "*"))
           (or(=(type(setq VALUEFILTER    (caddr  DLGRETURN)))'STR)(setq VALUEFILTER "*"))
           (or(=(type(setq NEWATTWERT     (cadddr DLGRETURN)))'STR)(setq NEWATTWERT ""))
       )
      (ATTSETVALUE (list BLOCKNAMEFILTER)(list TAGSTRINGFILTER)(list VALUEFILTER) NEWATTWERT)      
    )  
    (if(and(or(and(=(type(setq BLOCKNAMEFILTER (getstring "\nBLOCKNAME <\"*\"> :")))'STR)
                  (/= BLOCKNAMEFILTER "")
              )
              (setq BLOCKNAMEFILTER "*")
           )
           (or(=(type(setq TAGSTRINGFILTER (getstring "\nATTRIBUTNAME <\"*\"> :")))'STR)
              (setq TAGSTRINGFILTER "*")
           )
           (or(=(type(setq VALUEFILTER (getstring "\nATTRIBUTWERT <\"*\"> :")))'STR)
              (setq VALUEFILTER "*")
           )
           (or(=(type(setq NEWATTWERT (getstring "\nNEUER ATTRIBUTWERT <\"*\"> :")))'STR)
              (setq NEWATTWERT "")
           )
       )      
      (ATTSETVALUE (list BLOCKNAMEFILTER)(list TAGSTRINGFILTER)(list VALUEFILTER) NEWATTWERT)
    )
  )
  (vla-regen(vla-get-activedocument(vlax-get-acad-object))acAllViewports)
  (princ)
)  
;;; - ------------------------------------------------------------------------------- - ;
(defun ACM-ATTSETVALUE:INFO() 
  (mapcar
    'princ
    (list
      "\n\n"
      "\nACM-ATTSETVALUE :  ndern von Attributwerten nach Filter "
      "\n=================="  
      "\n(C) Thomas Krger 2025(tk@cad-od.de)"    
      "\nBefehlszeilenaufruf : ATTSETVALUE\n"
      "\n"    
    )
  )
  (princ)  
)
;;; - ------------------------------------------------------------------------------- - ;
(ACM-ATTSETVALUE:INFO)
(princ)